#include "proc.h"

#include "Suppressor.h"
#include <memory>

std::auto_ptr<Suppressor> g_pSuppressor;

LRESULT CALLBACK
WndProc(
		HWND hwnd,
		UINT uMsg,
		WPARAM wParam,
		LPARAM lParam 
		)
{
	switch( uMsg ) {
		case WM_CREATE:
			g_pSuppressor.reset(new Suppressor);
			break;

		case WM_CLOSE:
			g_pSuppressor.reset();
			DestroyWindow(hwnd);
			break;

		case WM_DESTROY:
			PostQuitMessage( 0 );
			break;
		default:
			return( DefWindowProc( hwnd, uMsg, wParam, lParam ) );
	}
	return 0;
}

